%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%     Minimax Regret in Practice - Four Examples on Treatment Choice    %%
%%                             Matlab Code                               %%
%%              by Patrick Eozenou, Javier Rivas and Karl Schlag         %%
%%                       2006 - Copyrights reserved                      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%----------Binomial Average Rule with Variance Reduction Trick-------------

function[probability_of_choosing_treatment_1] = f_BAR_with_VR(treatment_1, treatment_2, ...
    lower_interval, upper_interval, accuracy);

%Normalizing the value of the treatment samples
normalized_treatment_1 = (treatment_1 - lower_interval) / (upper_interval - lower_interval);
normalized_treatment_2 = (treatment_2 - lower_interval) / (upper_interval - lower_interval);

%Dropping observations from the samples
n_1 = numel(treatment_1);
n_2 = numel(treatment_2);
if n_1 == n_2;
    montecarlo_drops = 10^0;
    accuracy = 2*accuracy;
elseif n_1 > n_2;
    montecarlo_drops = 10^(accuracy/2);
end;

drop = 0;
while drop < montecarlo_drops;
  drop = drop + 1;
  x = normalized_treatment_1;
    if n_1 > n_2;
    difference = n_1 - n_2;
    which_ones_to_drop = randsample(n_1,difference);
    x(which_ones_to_drop,:) = [];
else;end;
n = n_2;

%Montecarlo
montecarlo_shots = 10^(accuracy/2);
shot = 0;
result = 0;
while shot < montecarlo_shots;
shot = shot + 1;

x_reloaded = x;
y_reloaded = normalized_treatment_2;

%Making the random pairs
for i=1:1:n;
  which_ones_to_pair = randsample(n-i+1,2,true);
  paired_sample(i,1) = x_reloaded(which_ones_to_pair(1,1),1) - y_reloaded(which_ones_to_pair(2,1),1);
  x_reloaded(which_ones_to_pair(1,1),:) = [];
  y_reloaded(which_ones_to_pair(2,1),:) = [];
end;

%Assigning values to the pairs
for i=1:1:n;
  flipping_coin = rand(1);
  if paired_sample(i,1)>0 & paired_sample(i,1)>flipping_coin;
     paired_sample_result_x(i,1) = 1;
     paired_sample_result_y(i,1) = 0;
  elseif paired_sample(i,1)<0 & -paired_sample(i,1)>flipping_coin;
     paired_sample_result_x(i,1) = 0;
     paired_sample_result_y(i,1) = 1;
  else;
     paired_sample_result_x(i,1) = 0;
     paired_sample_result_y(i,1) = 0;
  end;
end;

%Chosing the better treatment
if sum(paired_sample_result_x) > sum(paired_sample_result_y);
    result = result + (1 / montecarlo_shots);
elseif sum(paired_sample_result_x) < sum(paired_sample_result_y);
else;
    result = result + (.5 / montecarlo_shots);
end;
 
end; %Ending the 'Computing better treatment' loop
probability_of_choosing_treatment_1_on_this_drop(drop,1) = result;
end; %Ending the 'Dropping observations from the samples' loop
probability_of_choosing_treatment_1 = sum(probability_of_choosing_treatment_1_on_this_drop) / montecarlo_drops;